//*****************************************************************************
//                  Copyright (c) 2007, Lexmark International, Inc.           
//     THIS IS AN UNPUBLISHED WORK CONTAINING CONFIDENTIAL AND PROPRIETARY     
//        INFORMATION WHICH IS THE PROPERTY OF LEXMARK INTERNATIONAL, INC.     
//                                                                             
//   ANY DISCLOSURE, USE, OR REPRODUCTION, WITHOUT WRITTEN AUTHORIZATION FROM  
//              LEXMARK INTERNATIONAL, INC., IS STRICTLY PROHIBITED.           
//*****************************************************************************
//
// JSW.js handles the user interactions and information updates on the 
// JSWDialog.
//
//****************************************************************************

// Global variable to this java script
var hideInkStatus = true;

// Cache previous update values
var oldPage = 0;
var oldCopy = 0;
var oldPercent = 0;

// Cache element nodes for quick access during updates
var elementCurrentPage = null;
var elementCurrentCopy = null;
var elementProgressPercent = null;
var elementProgressBar = null;

//-----------------------------------------------------------------------------
// JSWLoaded()
//  Handle the onload event to load job name, total pages, and total copies 
//  onto the JWS dialog.
// 	When the user changes the screen dpi to something other than the default
// 	setting, all text font sizes and most images will be scaled accordingly.
// 	The progress bar will not be scaled because it is comprised of background
// 	images and background images cannot be scaled here.
//-----------------------------------------------------------------------------
function JSWLoaded()
{
	var scaledSize;

    // These items need to be populated before they can be scaled
	var elementFilePath = document.getElementById("FilePath");
	if (elementFilePath != null)
	{
        var jobName = parent.CommonJS.GetJobName();
	    elementFilePath.innerHTML = jobName;
    }

    var elementTotalPage = document.getElementById("TotalPage");
    if (elementTotalPage != null)
    {
        var totalPages = parent.CommonJS.GetTotalPages();
        elementTotalPage.innerHTML = totalPages;
    }

    var elementTotalCopy = document.getElementById("TotalCopy");
    if (elementTotalCopy != null)
    {
        var totalCopies = parent.CommonJS.GetTotalCopies();
        elementTotalCopy.innerHTML = totalCopies;
    }

    // Locate the document nodes that we will be interested in during updates
    elementCurrentPage = document.getElementById("CurrentPage");	
    elementCurrentCopy = document.getElementById("CurrentCopy");
    elementProgressBar = document.getElementById("JSWProgress");
    elementProgressPercent = document.getElementById("ProgressPercent");

	// If the screen dpi is not the default setting, we need to scale elements
	// in the JSW
	parent.ScaleJSW();

    // Hide the billboard page info controls if necessary
	var elementPageCount = document.getElementById("PageCount");
	var elementCopyCount = document.getElementById("CopyCount");
    var showPageInfo = parent.CommonJS.GetShowPageInfo();
    
    if(!showPageInfo)
    {
        // Hide page count control if it exists
        if(elementPageCount != null)
        {
            elementPageCount.style.display = "none";
        }
        // Hide copy count control if it exists
        if(elementCopyCount != null)
        {
            elementCopyCount.style.display = "none";
        }
    }
    else
	{
	    parent.ScalePageCopy(elementPageCount, elementCopyCount);
    }
		
    UpdateJSWInfo();
}

//-----------------------------------------------------------------------------
// UpdateJSWInfo()
//  Update JSW information on the JSW dialog including currentPage, currentCopy,
//  and progressPercent.  Only updates nodes that differ from their previous
//  values.
//-----------------------------------------------------------------------------
function UpdateJSWInfo()
{
    var currentPage = parent.CommonJS.GetCurrentPage();
    if((currentPage != oldPage) && (elementCurrentPage != null))
    {	    
        oldPage = currentPage;
        elementCurrentPage.innerHTML = currentPage;
    }

    var currentCopy = parent.CommonJS.GetCurrentCopy();
    if ((currentCopy != oldCopy) && (elementCurrentCopy != null))
    {
        oldCopy = currentCopy;
        elementCurrentCopy.innerHTML = currentCopy;
    }

    var progressPercent = parent.CommonJS.GetProgressPercent();
    if(progressPercent != oldPercent)
    {
        oldPercent = progressPercent;
        if (elementProgressPercent != null)
        {
            elementProgressPercent.innerHTML = progressPercent;
        }

        if (elementProgressBar != null)
        {
            elementProgressBar.Update(progressPercent);
        }
    }
}

//-----------------------------------------------------------------------------
// CancelButtonClick()
//  Handle onclick event for JSW dialog CancelButton.  It makes a call to the
//  controller JSWCallback method with CBCancelJob(=9) as the status value.
//-----------------------------------------------------------------------------
function CancelButtonClick()
{
    var CBCancelJob = 9; // predefined constant in guiinfo.h
    parent.CommonJS.JSWAction(CBCancelJob);
}

//-----------------------------------------------------------------------------
// InkStatusClick()
//  Handle onclick event for JSW dialog InkStatus link.  Initially, the ink
//  status will be hidden on the Billboard. Then if the user clicks the link,
//  the ink status will be displayed on Billboard.  Subsequent clicks on the
//  link will alternate ink status to be hidden or displayed on the Billboard.
//-----------------------------------------------------------------------------
function InkStatusClick()
{
    if (hideInkStatus)
    {
        parent.CommonJS.BBAction("INK_STATUS", 0);
        hideInkStatus = false;
    }
    else
    {
        parent.CommonJS.BBAction("CURRENT", 0);
        hideInkStatus = true;
    }
}

//-----------------------------------------------------------------------------
// getMouseDown()
//  Handle onmousedown event for the JSW portion of the dialog. It makes a call
//  to the gateway's MoveDialog method and initiates dragging. The handler
//  should be defined in the body of the JSW frame so that it is executed
//  there, instead of in the scope of the whole window.
//-----------------------------------------------------------------------------
function getMouseDown()
{
	parent.CommonJS.MouseButtonClick();
}
