/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2018 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/
#ifndef _NVRAM_TYPE_H_
#define _NVRAM_TYPE_H_


/*! "brief NVM_TYPE
 *    enum of nvram type
 */
typedef enum _NVRAM_YPE__
{
    NVM_NONE,
    NVM_IVCAM,
    NVM_BIOS,
    NVM_OTP,
    NVM_BIOS_OTP,
    NVM_EEPROM,
    NVM_BRCA016,
    NVM_24AA01,
    NVM_24AA32,
    NVM_CAT24C08,
    NVM_M24C64,
    NVM_DW9806B,
    NVM_CAT24C16,

    // below defines are for outside DDK use, don't remove or change in our project
    // "NVM_ex1" place holder, change to real name when needed
    NVM_EX1,
    NVM_EX2,
    NVM_EX3,
    NVM_EX4,
    NVM_EX5,

    // New NVM added to last in case to change above reserved values being used externally
    NVM_CAT24C64,
    NVM_24AA16,
    NVM_NUM
} NVM_TYPE;

#endif

