/*
 * INTEL CORPORATION PROPRIETARY INFORMATION
 * This software is supplied under the terms of a license agreement or
 * nondisclosure agreement with Intel Corporation and may not be
 * copied or disclosed except in accordance with the terms of that
 * agreement
 *
 * Copyright 2010 Intel Corporation. All Rights Reserved.
 */

#ifndef _SENSOR_FEATURE_H_
#define _SENSOR_FEATURE_H_

/*!
 * \brief Sensor features enum list
 *
 * \It is the parameter of SNSR_SET_EXT_FEATURE and SNSR_GET_EXT_FEATURE interface
 */
typedef enum __SNSR_EXT_FEATURE_
{
    SNSR_EXT_FEATURE_BRIGHTNESS,                            /*!< Soc sensor or external ISP Feature. Brightness. */
    SNSR_EXT_FEATURE_CONSTRAST,                             /*!< Soc sensor or external ISP Feature. Contrast. */
    SNSR_EXT_FEATURE_SATURATION,                            /*!< Soc sensor or external ISP Feature. Sataration. */
    SNSR_EXT_FEATURE_SHARPNESS,                             /*!< Soc sensor or external ISP Feature. Sharpness. */
    SNSR_EXT_FEATURE_HUE,                                   /*!< Soc sensor or external ISP Feature. Hue. */
    SNSR_EXT_FEATURE_BANDING,                               /*!< Soc sensor or external ISP Feature. Banding. */
    SNSR_EXT_FEATURE_WB,                                    /*!< Soc sensor or external ISP Feature. White Balance. */
    SNSR_EXT_FEATURE_EFFECT,                                /*!< Soc sensor or external ISP Feature. Effect. */
    SNSR_EXT_FEATURE_SCENE,                                 /*!< Soc sensor or external ISP Feature. Scence mode. */
    SNSR_EXT_FEATURE_BRACKET,                               /*!< Soc sensor or external ISP Feature. AE Bracket. */
    SNSR_EXT_FEATURE_BACKLIGHT_COMPENSATION,                /*!< Soc sensor or external ISP Feature. Bracket Compensation. */
    SNSR_EXT_FEATURE_EXPOSURE,                              /*!< Soc sensor or external ISP Feature. Exposure time. */
    SNSR_EXT_FEATURE_GAIN,                                  /*!< Soc sensor or external ISP Feature. Gain. */
    SNSR_EXT_FEATURE_ISO,                                   /*!< Soc sensor or external ISP Feature. ISO. */
    SNSR_EXT_FEATURE_FOCUS,                                 /*!< Soc sensor or external ISP Feature. Focus. */
    SNSR_EXT_FEATURE_FACE_DETECTION,                        /*!< Soc sensor or external ISP Feature. Face deteaction. */
    SNSR_EXT_FEATURE_METERING,                              /*!< Soc sensor or external ISP Feature. AE metering. */
    SNSR_EXT_FEATURE_AE,                                    /*!< Soc sensor or external ISP Feature. AE enable. */
    SNSR_EXT_FEATURE_AE_ROI,                                /*!< Soc sensor or external ISP Feature. AE ROI enable. */
    SNSR_EXT_FEATURE_AE_ROI_DATA,                           /*!< Soc sensor or external ISP Feature. AE ROI data. */
    SNSR_EXT_FEATURE_DVS,                                   /*!< Soc sensor or external ISP Feature. DVS. */
    SNSR_EXT_FEATURE_DIGITAL_ZOOM,                          /*!< Soc sensor or external ISP Feature. Digital Zoom. */
    SNSR_EXT_FEATURE_JPEG,                                  /*!< Soc sensor or external ISP Feature. Jpeg encode. */
    SNSR_EXT_FEATURE_SNAP_DURING_VIDEO,                     /*!< Soc sensor or external ISP Feature. SDV. */
    SNSR_EXT_FEATURE_STATE_STRUCT,                          /*!< Soc sensor or external ISP Feature. Status Structue. */
    SNSR_EXT_FEATURE_SENSOR_MODE,                           /*!< Soc sensor or external ISP Feature. Sensor Mode. */
    SNSR_EXT_FEATURE_CONTEXT_CONFIG,                        /*!< Soc sensor or external ISP Feature. Set one context resolution/format, and return back a virtual id for each stream. */
    SNSR_EXT_FEATURE_CONTEXT_ENABLE,                        /*!< Soc sensor or external ISP Feature. DVS. */
    SNSR_EXT_FEATURE_AE_AWB_LOCK,                           /*!< Soc sensor or external ISP Feature. AE, AWB lock. */
    SNSR_EXT_FEATURE_AE_STATUS,                             /*!< Soc sensor or external ISP Feature. AE status. */
    SNSR_EXT_FEATURE_AWB_STATUS,                            /*!< Soc sensor or external ISP Feature. AWB status. */
    SNSR_EXT_FEATURE_AF_1ST_STATUS,                         /*!< Soc sensor or external ISP Feature. AF first circle status. */
    SNSR_EXT_FEATURE_AF_2ND_STATUS,                         /*!< Soc sensor or external ISP Feature. AF second circle status. */
    SNSR_EXT_FEATURE_AUTO_FLASH,                            /*!< Soc sensor or external ISP Feature. Auto flash function. */
    SNSR_EXT_FEATURE_MIPICLK,                               /*!< Raw, Soc sensor or external ISP Feature. Bit rate per lane. */
    SNSR_EXT_FEATURE_TESTMODE,                              /*!< Raw sensor Feature. Sensor feature test mode (eg. color bar). */
    SNSR_EXT_FEATURE_LOCK_PARAMS,                           /*!< Raw sensor Feature. Sensor feature lock params (eg. exposure, gain). */
    SNSR_EXT_FEATURE_PRIVACY_LED,                           /*!< Raw sensor Feature. Sesnor privacy LED (turns on when camera active). */
    SNSR_EXT_FEATURE_ROI,                                   /*!< Raw sensor Feature. Region of interest params. */ 
    SNSR_EXT_FEATURE_STROBE_FRAME_PATTERN,                  /*!< Raw IR sensor Feature. Strobe frame pattern. */
    SNSR_EXT_FEATURE_RS_IR,                                 /*!<RAW IR sensor Feature. Rolling shutter IR sensor>.*/
    SNSR_EXT_FEATURE_IR_LED_INTENSITY,                      /*!<RAW IR sensor Feature. get IR LED intensity>.*/
    SNSR_EXT_FEATURE_VHDRMODE,                              /*! Feature for VHDR specific workarounds*/
    SNSR_EXT_FEATURE_EOF,
    SNSR_EXT_FEATURE_EMBDATA_MIRROR,                        /*! sensor embedded data mirror property*/
    SNSR_EXT_FEATURE_EMBDATA_BYTES,                         /*! sensor embedded line data bytes*/
    SNSR_EXT_FEATURE_PDAF_MIRROR,                           /*! sensor pdaf data mirror property*/
    SNSR_EXT_FEATURE_TRIGGER_MODE,                          /*! sensor operation mode.*/
    SNSR_EXT_FEATURE_NUM,
} SNSR_EXT_FEATURE_ID;

/*!
* \brief Soc Sensor or External ISP features Color effect
*/
typedef enum __FEATRUE_COLOR_EFFECTS
{
    EFFECT_NORNAL,                                          /*!< Color effect. Normal. */
    EFFECT_ALIEN,                                           /*!< Color effect. Alien. */
    EFFECT_ANTIQUE,                                         /*!< Color effect. Antique. */
    EFFECT_BLACK_WHITE,                                     /*!< Color effect. Black white. */
    EFFECT_EMBOSS,                                          /*!< Color effect. Emboss. */
    EFFECT_EMBOSS_COLORED,                                  /*!< Color effect. Emboss colored. */
    EFFECT_GRAYSCALE,                                       /*!< Color effect. Grayscale. */
    EFFECT_NEGATIVE,                                        /*!< Color effect. Negative. */
    EFFECT_BLUISH,                                          /*!< Color effect. Bluish. */
    EFFECT_GREENISH,                                        /*!< Color effect. Greensish. */
    EFFECT_REDISH,                                          /*!< Color effect. Redish. */
    EFFECT_POSTERIZE1,                                      /*!< Color effect. Posterize1. */
    EFFECT_POSTERIZE2,                                      /*!< Color effect. Posterize2. */
    EFFECT_SEPIA1,                                          /*!< Color effect. Sepia1. */
    EFFECT_SEPIA2,                                          /*!< Color effect. Sepia2. */
    EFFECT_SKETCH,                                          /*!< Color effect. Sketch. */
    EFFECT_SOLARIZE,                                        /*!< Color effect. Solarize. */
    EFFECT_FOGGY,                                           /*!< Color effect. Foggy. */
    EFFECT_NUM,                                             /*!< Color effect. Number of Effect. */
}SR_COLOR_EFFECT;

/*!
* \brief Soc Sensor or External ISP features Scene mode
*/
typedef enum __FEATUER_SCENE_MODE
{
    SCENE_AUTO,                                             /*!< Scene Mode. Auto. */
    SCENE_NORMAL,                                           /*!< Scene Mode. Normal. */
    SCENE_PORTRAIT,                                         /*!< Scene Mode. PORTRAIT. */
    SCENE_LANDSCAPE,                                        /*!< Scene Mode. LANDSCAPE. */
    SCENE_SPORT,                                            /*!< Scene Mode. SPORT. */
    SCENE_CLOSEUP,                                          /*!< Scene Mode. CLOSEUP. */
    SCENE_NIGHT,                                            /*!< Scene Mode. NIGHT. */
    SCENE_TWILIGHT,                                         /*!< Scene Mode. TWILIGHT. */
    SCENE_BACKLIT,                                          /*!< Scene Mode. BACKLIT. */
    SCENE_HIGH_SENSITIVITY,                                 /*!< Scene Mode. HIGH_SENSITIVITY. */
    SCENE_NIGHT_PORTRAIT,                                   /*!< Scene Mode. NIGHT_PORTRAIT. */
    SCENE_BEACH,                                            /*!< Scene Mode. BEACH. */
    SCENE_DOCUMENT,                                         /*!< Scene Mode. DOCUMENT. */
    SCENE_PARTY,                                            /*!< Scene Mode. PARTY. */
    SCENE_FIREWORKS,                                        /*!< Scene Mode. FIREWORKS. */
    SCENE_SUNSET,                                           /*!< Scene Mode. SUNSET. */
    SCENE_NUM,
}SR_SCENE_MODE;

/*!
* \brief Soc Sensor or External ISP features white balance
*/
typedef enum __FEATUER_WHITE_BALANCE
{
    WB_AUTO,                                                /*!< White Balance. Auto. */
    WB_MEASURE,                                             /*!< White Balance. Measure. */
    WB_MANUAL,                                              /*!< White Balance. Manual. */
    WB_D75,                                                 /*!< White Balance. D75. */
    WB_D65,                                                 /*!< White Balance. D65. */
    WB_D50,                                                 /*!< White Balance. D50. */
    WB_CWF,                                                 /*!< White Balance. CWF. */
    WB_A,                                                   /*!< White Balance. A. */
    WB_HORIZON,                                             /*!< White Balance. Horizon. */
    WB_WHITE_POINT,                                         /*!< White Balance. White Point. */
    WB_NUM,
}SR_WHITE_BALANCE;

/*!
* \brief Soc Sensor or External ISP features Bracket
*/
typedef enum __FEATUER_BRACKET
{
    BRACKET_BRIGHTNESS,                                    /*!< AE Bracket. Brightness. */
    BRACKET_EXPOSURE,                                      /*!< AE Bracket. Exposure. */
    BRACKET_ISO,                                           /*!< AE Bracket. ISO. */
    BRACKET_AWBQX,                                         /*!< AE Bracket. AWBQX. */
    BRACKET_AWBQY,                                         /*!< AE Bracket. AWBQY. */
    BRACKET_CONTRAST,                                      /*!< AE Bracket. Contrast. */
    BRACKET_AF_RELATIVE,                                   /*!< AE Bracket. AF Relative. */
    BRACKET_LENS,                                          /*!< AE Bracket. Lens. */
    BRACKET_NUM,
}SR_BRACKET;

/*!
* \brief Soc Sensor or External ISP features AE metering
*/
typedef enum __FEATUER_METERING
{
    METERING_AUTO_AVERAGE,                                 /*!< AE Metering. Auto Average. */
    METERING_AUTO_WIDE_CENTER,                             /*!< AE Metering. Auto Wide Center. */
    METERING_AUTO_NARROW_CENTER,                           /*!< AE Metering. Auto Narrow center. */
    METERING_AUTO_SPOT,                                    /*!< AE Metering. Auto Spot. */
    METERING_MANUAL,                                       /*!< AE Metering. Manual. */
    METERING_NUM,
}SR_METERING;

/*!
* \brief Soc Sensor or External ISP features Face detection
*/
typedef enum __FEATUER_FACE
{
    FACE_ON,                                               /*!< Face Detection. On. */
    FACE_SMILE_ON,                                         /*!< Face Detection. Smile On. */
    FACE_OFF,                                              /*!< Face Detection. Off. */
    FACE_NUM
}SR_FACE;

/*!
* \brief Soc Sensor or External ISP features AE mode
*/
typedef enum __FEATUER_AE
{
    AE_NORNAL,                                             /*!< AE mode. Normal. */
    AE_TIME,                                               /*!< AE mode. Time. */
    AE_GAIN,                                               /*!< AE mode. Gain. */
    AE_ISO,                                                /*!< AE mode. ISO. */
    ME_BV,                                                 /*!< AE mode. Manual BV. */
    ME_BV_TIME,                                            /*!< AE mode. Manual BV Timing. */
    ME_BV_GAIN,                                            /*!< AE mode. Manual BV Gain. */
    ME_BV_ISO,                                             /*!< AE mode. Manual BV ISO. */
    ME_TIME_GAIN,                                          /*!< AE mode. Manual Timing Gain. */
    AE_NUM,
}SR_AE;

/*!
* \brief Soc Sensor or External ISP features Flicker
*
* \It should be mapping with KS_POWERLINEFREQUENCY
*/
typedef enum __FEATUER_FLICKER
{
    FLICKER_OFF,                                           /*!< Flicker. Off. */
    FLICKER_FORCE_50HZ,                                    /*!< Flicker. 50Hz. */
    FLICKER_FORCE_60HZ,                                    /*!< Flicker. 60Hz. */
    FLICKER_AUTO,                                          /*!< Flicker. Auto. */
    FLICKER_NUM,
}SR_FLICKER;

/*!
* \brief Soc Sensor or External ISP features DVS enable
*/
typedef enum __FEATUER_DVS
{
    DVS_OFF,                                               /*!< DVS. Off. */
    DVS_ON,                                                /*!< DVS. On. */
    DVS_NUM,
}SR_DVS;

/*!
* \brief Soc Sensor or External ISP features AE ROI mode
*/
typedef enum __FEATUER_AE_ROI
{
    AE_ROI_DISABLE,                                         /*!< AE ROI. Disable. */
    AE_ROI_FACE,                                            /*!< AE ROI. Face. */
    AE_ROI_USER,                                            /*!< AE ROI. User. */
    AE_ROI_NUM
}SR_AE_ROI;

/*!
* \brief Soc Sensor or External ISP features AE ROI data
*/
typedef struct __FEATURE_AE_AF_ROI__
{
    ULONG x0;                                                /*!< AE AF ROI Data. x0. */
    ULONG y0;                                                /*!< AE AF ROI Data. y0. */
    ULONG x1;                                                /*!< AE AF ROI Data. x1. */
    ULONG y1;                                                /*!< AE AF ROI Data. y1. */
}SR_AEAF_ROI;

/*!
* \brief Soc Sensor or External ISP features Sensor Mode
*/
typedef enum __FEATUER_SENSOR_MODE
{
    SENSOR_PRIMARY,                                          /*!< Sensor Mode for 3D camera case. Primary camera. */
    SENSOR_SECONDARY,                                        /*!< Sensor Mode for 3D camera case. Secondary camera. */
    SENSOR_SIDE_BY_SIDE,                                     /*!< Sensor Mode for 3D camera case. 3D camera mode. */
    SENSOR_NUM,
}SR_SENSOR_MODE;

/*!
* \brief Soc Sensor or External ISP features Output format
*/
typedef enum __OUTFMT__
{
    FMT_YUV422,                                              /*!< Output format. YUV422. */
    FMT_RAW10,                                               /*!< Output format. RAW10. */
    FMT_JPEG,                                                /*!< Output format. JPEG. */
    FMT_NUM
}SR_OUT_FMT;

/*!
* \brief Soc Sensor or External ISP features output streaming information
*/
typedef struct __STREAM_RES__
{
    BOOLEAN Flag;                                            /*!< Sensor Stream Information. Enable. */
    ULONG ChannelID;                                         /*!< Sensor Stream Information, output. Virtual Channel ID. */
    ULONG Width;                                             /*!< Sensor Stream Information, input. Resolution Width. */
    ULONG Height;                                            /*!< Sensor Stream Information, input. Resolution Height. */
    SR_OUT_FMT Format;                                       /*!< Sensor Stream Information, input. Resolution Format. */
}STREAM_RES;

/*!
* \brief Soc Sensor or External ISP features Sensor context
*/
typedef struct __FEATURE_CONTEXT_CONFIG__
{
    SNSR_MODE Context;                                       /*!< Stream context. Sensor Mode. */
    STREAM_RES Main;                                         /*!< Stream context. Sensor Main Streaming. */
    STREAM_RES Auxi;                                         /*!< Stream context. Sensor Auxi Streaming. */
}SR_CONTEXT_CONFIG;

/*!
* \brief Soc Sensor or External ISP features Context enable
*/
typedef struct __FEATURE_CONTEXT_ENABLE__
{
    SNSR_MODE Context;                                       /*!< Stream context enable. Sensor Mode. */
    BOOLEAN Enable;                                          /*!< Stream context enable. Sensor Context enable. */
    ULONG ChannelId;                                         /*!< Stream context enable. Sensor Context virtual channel ID. */
}SR_CONTEXT_ENABLE;

/*!
* \brief Raw IR sensor strobe frame pattern
*/
#define IR_STROBE_ALL_ON           0xFF                      /*!< every frame being illuminated. */
#define IR_STROBE_ALTERNATE_ON_OFF 0xAA                      /*!< every other frame being illuminated. */
#define IR_STROBE_1_ON_3_OFF       0x88                      /*!< 1 frame on, 3 frames off, and repeat. */
#define IR_STROBE_2_ON_2_OFF       0xCC                      /*!< 2 frame on, 2 frames off, and repeat. */

#endif
